package com.onsiteservice.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author 潘维吉
 * @date 2020/8/12 11:24
 * @email 406798106@qq.com
 * @description 精确的加减乘除运算工具类
 */
public class ArithUtils {

    /**
     * 默认除法运算精度
     */
    private static final int DEF_DIV_SCALE = 10;


    /**
     * 提供精确的加法运算
     */
    public static double add(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.add(b2).doubleValue();
    }

    /**
     * 精确的减法运算
     */
    public static double subtract(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).doubleValue();
    }

    /**
     * 精确的乘法运算
     */
    public static double multiply(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).doubleValue();
    }

    /**
     * 提供（相对）精确的除法运算，当发生除不尽的情况时
     * 精确到小数点后10位的数字四舍五入
     */
    public static double divide(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, DEF_DIV_SCALE, RoundingMode.HALF_UP).doubleValue();
    }

    public static void main(String[] args) {
        System.out.println("0.05 + 0.01 = " + ArithUtils.add(0.05, 0.01));
        System.out.println("1.0 - 0.42 = " + ArithUtils.subtract(1.0, 0.42));
        System.out.println("4.015*100 = " + ArithUtils.multiply(4.015, 100));
        System.out.println("123.3/100 = " + ArithUtils.divide(123.3, 100));
    }

}
