package com.onsiteservice.common.service.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author 潘维吉
 * @date 2021/10/9 17:09
 * @email 406798106@qq.com
 * @description
 */
@ApiModel("微信生成小程序码参数")
@Getter
@Setter
@ToString
public class MiniQrCodeDTO implements Serializable {

    @ApiModelProperty(value = "场景(编码的路径参数 不加?分号)", required = true)
    @NotBlank(message = "场景不能为空")
    private String scene;

    @ApiModelProperty(value = "已经发布的小程序存在的页面路径(最前面不要填加 /, 不能携带参数, 不填默认跳主页面)")
    private String path;

    @ApiModelProperty(value = "二维码的宽度(单位 px, 最小 280px, 最大 1280px 默认430px)")
    private Integer width;

}
