package com.onsiteservice.common.service;

import com.onsiteservice.common.redis.RedisUtils;
import com.onsiteservice.util.aliyun.SmsUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 业务短信服务
 */
@Service
@Transactional(rollbackFor = Exception.class)
@Slf4j
public class CommonSmsService {

    @Value("${spring.profiles.active}")
    private String env;

    @Value("${aliyun.sms.template-code.change-phone}")
    private String changePhoneTmpCode; // 手机号换绑

    @Value("${aliyun.sms.template-code.payable}")
    private String payableTmpCode; // 通知用户完成估价请支付

    @Value("${aliyun.sms.template-code.dispatched}")
    private String dispatchedTmpCode; // 通知用户已经派单

    @Value("${aliyun.sms.template-code.redispatched}")
    private String redispatchedTmpCode; // 通知用户已经重新派单

    @Value("${aliyun.sms.template-code.paid}")
    private String paidTmpCode; // 手机号换绑

    @Value("${aliyun.sms.template-code.valuator}")
    private String valuatorTmpCode; // 通知客户已派估价员

    @Value("${aliyun.sms.template-code.revaluator}")
    private String revaluatorTmpCode; // 通知客户已重新指派估价员

    @Value("${aliyun.sms.sign}")
    private String sign;

    @Resource
    private SmsUtils smsUtils;
    @Resource
    private RedisUtils redisUtil;

    /***
     * 禁用短信方法
     */
    private boolean disableSms() {
//        return "dev".equals(env);
        return false;
    }


    /***
     * 发送改变信息验证码
     */
    public void sendChangePhone(String code, String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, changePhoneTmpCode, code, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

    public void payable(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, payableTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

    public void dispatched(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, dispatchedTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }
    public void redispatched(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, redispatchedTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

    public void paid(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, paidTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

    public void valuator(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, valuatorTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

    public void revaluator(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return;
        }
        try {
            smsUtils.send(sign, revaluatorTmpCode, null, phone);
        } catch (Exception e) {
            log.error("发送短信错误", e);
        }
    }

}
