package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.service.sys.SysBusinessOperateService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.entity.sys.SysBusinessOperate;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @author wangning
 * @date 2019-10-11 09:02
 * SysBusinessOperateController控制类
 */
@RestController
@RequestMapping("/sys/business/operate")
@Validated
public class SysBusinessOperateController {

    @Resource
    private SysBusinessOperateService sysBusinessOperateService;

    /**
     * 分页查询列表
     *
     * @param page 分页参数
     * @return 分页数据
     */
    @GetMapping("/list")
    public Result<PageInfoVO<SysBusinessOperate>> pageList(@Validated PageParams page) {
        PageHelper.startPage(page.getPage(), page.getSize());
        List<SysBusinessOperate> list = sysBusinessOperateService.selectAll();
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable @Positive Integer id) {
        SysBusinessOperate sysBusinessOperate = sysBusinessOperateService.selectByPrimaryKey(id);
        return ResultGenerator.success(sysBusinessOperate, "根据id获取详情");
    }

    /**
     * 新增保存对象
     *
     * @param sysBusinessOperate 保存对象
     */
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated SysBusinessOperate sysBusinessOperate) {
        sysBusinessOperateService.insertSelective(sysBusinessOperate);
        return ResultGenerator.success(sysBusinessOperate, "新增成功");
    }

    /**
     * 更新修改对象
     *
     * @param sysBusinessOperate 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated SysBusinessOperate sysBusinessOperate) {
        sysBusinessOperateService.updateByPrimaryKeySelective(sysBusinessOperate);
        return ResultGenerator.success(sysBusinessOperate, "更新成功");
    }

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Integer id) {
        sysBusinessOperateService.deleteByPrimaryKey(id);
        return ResultGenerator.success("删除成功");
    }


    @GetMapping("/getByBusiness/{id}")
    public Result getByBusinessOpt(@PathVariable @Positive Long id) {
        return ResultGenerator.success(sysBusinessOperateService.getByBusinessId(id), "根据业务id获得操作");
    }

    @PostMapping("/batchDelete")
    public Result batchDelete(@RequestBody List<Long> ids) {
        sysBusinessOperateService.deleteBatch(ids);
        return ResultGenerator.success(true, "删除成功");
    }
}
