package com.onsiteservice.miniapp.service.category;

import com.onsiteservice.constant.constant.BizConstants;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.mapper.banner.BannerMapper;
import com.onsiteservice.dao.mapper.home.HomeNoticeMapper;
import com.onsiteservice.entity.banner.Banner;
import com.onsiteservice.entity.home.HomeNotice;
import com.onsiteservice.miniapp.controller.category.vo.BannerVO;
import com.onsiteservice.miniapp.controller.category.vo.HomeNoticeVO;
import com.onsiteservice.miniapp.controller.category.vo.HomeViewVO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceCategoryVO;
import com.onsiteservice.util.AttrCopyUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class HomeCommonService {


    @Resource
    private BannerMapper bannerMapper;

    @Resource
    private HomeNoticeMapper homeNoticeMapper;

    @Resource
    private ServiceCategoryService serviceCategoryService;


    public Result<HomeViewVO> home() {
        // 轮播图
        List<Banner> bannerList = bannerMapper.selectAll();
        List<BannerVO> bannerVOList = bannerList.parallelStream()
                .map(e -> AttrCopyUtils.copy(e, new BannerVO())).collect(Collectors.toList());

        // 公告
        Condition c = new Condition(HomeNotice.class);
        c.createCriteria().andEqualTo(BizConstants.CommonConstants.RELEASE_STATUS, 2);
        List<HomeNotice> noticeList = homeNoticeMapper.selectByCondition(c);
        List<HomeNoticeVO> homeNoticeVOList = noticeList.parallelStream()
                .map(e -> AttrCopyUtils.copy(e, new HomeNoticeVO())).collect(Collectors.toList());

        // 服务
        Result<List<ServiceCategoryVO>> serviceResult = serviceCategoryService.list(null);

        HomeViewVO homeViewVO = HomeViewVO.builder()
                .bannerList(bannerVOList)
                .noticeList(homeNoticeVOList)
                .serviceList(serviceResult.getData())
                .build();

        return ResultGenerator.success(homeViewVO);
    }


}
