package com.onsiteservice.miniapp.controller.order.dto;

import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Size;

/**
 * <P></P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 14:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("分页查询订单请求模型")
public class PageServiceOrderDTO extends PageParams {

    @ApiModelProperty(value = "订单状态: 0表示全部,1表示...", required = true)
    private Integer orderStatus;

    @ApiModelProperty(value = "月份")
    @Size(min = 6, max = 6, message = "月份格式不正确[yyyyMM]")
    private String month;

    @ApiModelProperty(value = "模糊查询关键字,可输入客户名,服务地址,服务类型")
    private String keyWord;

}
