package com.onsiteservice.miniapp.controller.log;

import com.onsiteservice.entity.service.ServiceOrderLog;
import com.onsiteservice.miniapp.service.log.ServiceOrderLogService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;
import static com.onsiteservice.core.result.ResultGenerator.fail;

/**
 * @author 潘维吉
 * @date 2022-07-11 11:37
 * @description ServiceOrderLogController控制类
 */
@ApiIgnore
@Api(tags = "ServiceOrderLogController")
@RestController
@RequestMapping("/service/order/log")
@Validated
public class ServiceOrderLogController {

    @Resource
    private ServiceOrderLogService serviceOrderLogService;


    @ApiOperation(value = "分页查询列表", notes = "作者: 潘维吉")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(serviceOrderLogService.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: 潘维吉")
    @GetMapping("/{id}")
    public Result<ServiceOrderLog> getDetails(@PathVariable @Positive Long id) {
        return success(serviceOrderLogService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: 潘维吉")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated ServiceOrderLog serviceOrderLog) {
        return success(serviceOrderLogService.saveOrUpdate(serviceOrderLog), serviceOrderLog.getId() == null ? "新增成功" : "修改成功");
    }

    @ApiOperation(value = "根据id删除", notes = "作者: 潘维吉")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(serviceOrderLogService.deleteByPrimaryKey(id), "删除成功");
    }

}
