package com.onsiteservice.miniapp.controller.category.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

@Data
@ApiModel("服务大类值对象")
public class ServiceCategoryVO {

    @ApiModelProperty(value = "服务大类id")
    private Integer id;

    @ApiModelProperty(value = "大类服务名")
    private String serviceName;

    @ApiModelProperty(value = "服务顺序")
    private Integer sequence;

    @ApiModelProperty(value = "图片url")
    private String img;

    @ApiModelProperty(value = "子类信息")
    private List<ServiceSubclassVO> children;

    @ApiModelProperty("标题颜色码")
    private String titleColor;

    @ApiModelProperty("背景颜色码")
    private String backColor;

    @ApiModelProperty("文案备注")
    private String description;

}