package com.onsiteservice.miniapp.controller.category;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import com.onsiteservice.miniapp.controller.category.dto.PageServiceCategoryDTO;
import com.onsiteservice.miniapp.controller.category.vo.ServiceCategoryVO;
import com.onsiteservice.miniapp.service.category.ServiceCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;

import java.util.List;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * <P>服务大类模块</P>
 *
 * @author 李宁
 * @version v1.0
 * @since 2022/7/7 08:51
 */
@Api(tags = "服务大类模块")
@RestController
@RequestMapping("/category/")
@Validated
public class ServiceCategoryController {

    @Resource
    private ServiceCategoryService serviceCategoryService;


    @ApiOperation(value = "查询服务大类")
    @GetMapping("list")
    public Result<List<ServiceCategoryVO>> list(@RequestParam(required = false) String keyWord) {
        return serviceCategoryService.list(keyWord);
    }

    /*@ApiOperation(value = "分页查询服务大类")
    @PostMapping("page")
    public Result<PageInfoVO<ServiceCategoryVO>> getPage(@RequestBody @NonNull @Validated PageServiceCategoryDTO dto) {
        return serviceCategoryService.getPage(dto);
    }*/


}
