package com.onsiteservice.miniapp.controller.area;

import com.onsiteservice.entity.area.ServiceArea;
import com.onsiteservice.miniapp.service.area.ServiceAreaService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.dao.common.page.PageParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;
import static com.onsiteservice.core.result.ResultGenerator.fail;

/**
 * @author 潘维吉
 * @date 2022-07-08 09:11
 * @description ServiceAreaController控制类
 */
@ApiIgnore
@Api(tags = "ServiceAreaController")
@RestController
@RequestMapping("/service/area")
@Validated
public class ServiceAreaController {

    @Resource
    private ServiceAreaService serviceAreaService;


    @ApiOperation(value = "分页查询列表", notes = "作者: 潘维吉")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated PageParams param) {
        return success(serviceAreaService.getPage(param), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: 潘维吉")
    @GetMapping("/{id}")
    public Result<ServiceArea> getDetails(@PathVariable @Positive Long id) {
        return success(serviceAreaService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: 潘维吉")
    @PostMapping("/save-or-update")
    public Result saveOrUpdate(@RequestBody @NonNull @Validated ServiceArea serviceArea) {
        return success(serviceAreaService.saveOrUpdate(serviceArea), serviceArea.getId() == null ? "新增成功" : "修改成功");
    }

    @ApiOperation(value = "根据id删除", notes = "作者: 潘维吉")
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        return success(serviceAreaService.deleteByPrimaryKey(id), "删除成功");
    }

}
