package com.onsiteservice.entity.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("系统用户表")
@Table(name = "sys_user")
public class SysUser implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 用户名
     */
    @Column(name = "user_name")
    @ApiModelProperty("用户名")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty("密码")
    private String password;

    /**
     * 真实姓名
     */
    @Column(name = "real_name")
    @ApiModelProperty("真实姓名")
    private String realName;

    /**
     * 头像url
     */
    @Column(name = "avatar_url")
    @ApiModelProperty("头像url")
    private String avatarUrl;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 性别 0: 未知 1: 男 2: 女
     */
    @ApiModelProperty("性别 0: 未知 1: 男 2: 女")
    private Integer sex;

    /**
     * 是否上帝用户 0: 否 1: 是
     */
    @Column(name = "is_god")
    @ApiModelProperty("是否上帝用户 0: 否 1: 是")
    private Boolean isGod;

    /**
     * 是否启用 0: 禁用 1: 启用
     */
    @Column(name = "is_enabled")
    @ApiModelProperty("是否启用 0: 禁用 1: 启用")
    private Boolean isEnabled;

    /**
     * 修改人
     */
    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;
}