package com.onsiteservice.entity.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@ApiModel("服务订单表")
@Table(name = "service_order")
public class ServiceOrder implements Serializable {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 订单号
     */
    @Column(name = "order_no")
    @ApiModelProperty("订单号")
    private String orderNo;

    /**
     * 服务名
     */
    @Column(name = "service_name")
    @ApiModelProperty("服务名")
    private String serviceName;

    /**
     * 账号
     */
    @Column(name = "account_no")
    @ApiModelProperty("账号")
    private Long accountNo;

    /**
     * 服务类型id
     */
    @Column(name = "subclass_id")
    @ApiModelProperty("服务类型id")
    private Integer subclassId;

    /**
     * 服务地址id
     */
    @Column(name = "address_id")
    @ApiModelProperty("服务地址id")
    private Long addressId;

    @Column(name = "name")
    @ApiModelProperty("客户名")
    private String name;

    @Column(name = "phone")
    @ApiModelProperty("客户服务手机号")
    private String phone;

    @Column(name = "address")
    @ApiModelProperty("客户服务地址")
    private String address;

    /**
     * 期望上门时间
     */
    @Column(name = "expect_arrival_time")
    @ApiModelProperty("期望上门时间")
    private Date expectArrivalTime;

    /**
     * 服务数量
     */
    @ApiModelProperty("服务数量")
    private Integer num;

    /**
     * 服务需求说明
     */
    @Column(name = "demand_desc")
    @ApiModelProperty("服务需求说明")
    private String demandDesc;

    /**
     * 是否阅读协议：1已阅读，0未阅读
     */
    @Column(name = "read_agreement")
    @ApiModelProperty("是否阅读协议：1已阅读，0未阅读")
    private Boolean readAgreement;

    /**
     * 订单状态：1已预约，2已派单，3进行中，4完成，5取消，6已评价
     */
    @Column(name = "order_status")
    @ApiModelProperty("订单状态：1已预约，2已派单，3进行中，4完成，5取消，6已评价")
    private Integer orderStatus;

    /**
     * 价格
     */
    @Column(name = "price")
    @ApiModelProperty("订单价格")
    private BigDecimal price;

    /**
     * 服务订单备注字段
     */
    @Column(name = "remark")
    @ApiModelProperty("服务订单备注字段")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    @Column(name = "valuator_id")
    @ApiModelProperty("估价员id")
    private Long valuatorId;


    private static final long serialVersionUID = 1L;
}