package com.onsiteservice.entity.base;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
@ApiModel("异常日志表")
@Table(name = "base_error_log")
public class BaseErrorLog implements Serializable {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 项目名称
     */
    @Column(name = "project_name")
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 运行环境
     */
    @ApiModelProperty("运行环境")
    private String environment;

    /**
     * 错误码
     */
    @Column(name = "error_code")
    @ApiModelProperty("错误码")
    private String errorCode;

    /**
     * 运行平台
     */
    @ApiModelProperty("运行平台")
    private String platform;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 日志异常信息
     */
    @ApiModelProperty("日志异常信息")
    private String content;

    private static final long serialVersionUID = 1L;
}