package com.onsiteservice.dao.util;

import tk.mybatis.mapper.genid.GenId;

import java.util.UUID;

/**
 * @author 潘维吉
 * @date 2021/11/29 11:41
 * @email 406798106@qq.com
 * @description 生成分布式ID唯一标识
 * 配置通用mapper的@KeySql注解使用或 @GeneratedValue(strategy = GenerationType.IDENTITY, generator = GenIdKey.UUID_SHORT)
 */
public class GenIdKey implements GenId<Long> {

    /**
     * Mysql无符号uuid整数  全局唯一主键标识  算法uuid_short()长度可能是17或20情况bigint(20)无法存储
     */
    public static final String UUID_SHORT = "select if(length(uuid_short())>=17,substring(uuid_short(),-17),(uuid_short()))";

    @Override
    public Long genId(String s, String s1) {
        return Long.valueOf(UUID.randomUUID().toString());
    }
}
