package com.onsiteservice.dao.common.extra;


import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.UpdateProvider;
import tk.mybatis.mapper.annotation.RegisterMapper;

import java.util.List;

/**
 * @author 潘维吉
 * @date 2019/12/27 14:49
 * @email 406798106@qq.com
 * @description 自定义批量更新通用Mapper接口 null值会被更新
 */
@RegisterMapper
public interface UpdateListMapper<T> {

    /**
     * 根据Example条件批量更新实体`record`包含的所有的属性值
     *
     * @return
     */
    @Options(useGeneratedKeys = true)
    @UpdateProvider(type = UpdateListProvider.class, method = "dynamicSQL")
    int updateList(List<? extends T> recordList);
}
