package com.onsiteservice.core.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;

/**
 * @author 潘维吉
 * @date 2018-08-08
 * Security安全配置类
 */
@ConditionalOnProperty(prefix = "project.security", name = {"enabled"}, matchIfMissing = true)
@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    /**
     * 安全配置
     *
     * @param httpSecurity
     * @throws Exception
     */
    @Override
    protected void configure(HttpSecurity httpSecurity) throws Exception {
        httpSecurity
                .cors().and()     // 开启cors跨域
                .csrf().disable() // 禁用CSRF跨站请求伪造攻击 前后端分离的项目jwt验证可关闭 不分离的建议开启 默认开启
                .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and() // 基于token 不需要session
                .authorizeRequests()
                .anyRequest().permitAll() // 资源不需要验证，直接可以请求 jwt方式验证
                .and().headers().xssProtection().xssProtectionEnabled(true);  // 启用跨域脚本XSS保护
        //.antMatchers(HttpMethod.OPTIONS, "/**").permitAll(); // 根据请求方法类型和路径授权保护
    }

}
