package com.onsiteservice.constant.constant;

/**
 * 字典表常量
 */
public class DictConstants {

    /**
     * ------------------系统字典数据------------------
     */

    /**
     * 字典类型 1.系统默认 2.自定义
     */
    public final static String SYS_DICT_CATEGORY = "SYS0000";

    /**
     * 启用状态 0 禁用 1 启用
     */
    public final static String AVAILABLE_STATUS = "SYS0001";

    /**
     * 是否状态 0 否 1 是
     */
    public final static String WHETHER_STATUS = "SYS0002";

    public class WhetherStatus {
        public static final int NO = 0; // 否
        public static final int YES = 1; // 是
    }

    /**
     * 是否删除 0 未删除 1 已删除
     */
    public final static String DELETE_STATUS = "SYS0003";

    public class DeleteStatus {
        public static final int NOT_DELETED = 0; // 未删除
        public static final int DELETED = 1; // 已删除
    }

    /**
     * 性别
     * mybatis xml中使用常量${@com.monorepo.constant.DictConstants$SEX@MAN}
     */
    public final static String SEX = "SYS0004";

    public class Sex {
        public static final int UNKNOWN = 0; // 未知
        public static final int MAN = 1; // 男
        public static final int WOMAN = 2; //女
    }

    /**
     * 系统参数 1 整型 2 字符串  3 富文本 4 图片 5 文件
     */
    public final static String SYS_PARAM_TYPE = "SYS0005";

    /**
     * 成功状态 0 失败 1 成功
     */
    public final static String SUCCESS_STATUS = "SYS0006";

    public class SuccessStatus {
        public static final int FAIL = 0; // 失败
        public static final int SUCCESS = 1; // 成功
    }



    /**
     * ------------------业务自定义字典数据------------------
     */
    // 小程序用户角色类型
    public final static String ROLE_TYPE = "BIZ0001";

    // 订单状态
    public final static String ORDER_STATUS = "BIZ0002";


}
