package com.onsiteservice.common.socket;


import com.onsiteservice.constant.constant.Constants;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

import java.util.Map;

/**
 * @author 潘维吉
 * @date 2019-01-19 16:21
 * Websocket的握手请求拦截器  可JWT token鉴权
 */
@Component
@Slf4j
public class SocketInterceptor implements HandshakeInterceptor {

    /**
     * 握手之前执行该方法, 继续握手返回true, 中断握手返回false. 通过attributes参数设置WebSocketSession的属性
     */
    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response,
                                   WebSocketHandler wsHandler, Map<String, Object> attributes) {
        // log.info("Http协议转换WebSocket协议进行前, 握手前" + request.getURI());
        // http协议转换WebSocket协议进行前，这里可通过token信息判断用户是否合法
        if (request instanceof ServletServerHttpRequest) {
            // HttpServletRequest servletRequest = ((ServletServerHttpRequest) request).getServletRequest();
            String userId = request.getURI().toString().split("userId=")[1];
            if (StringUtils.isBlank(userId)) {
                log.error("Websocket的握手请求拦截器: 用户id空 无效请求!");
                return false;
            } else {
                log.info("Websocket的握手请求拦截器: 当前session的userId=" + userId);
                // 存入session中获取到当前登录的用户信息
                attributes.put(Constants.WEBSOCKET_USER_ID, userId);
                return true;
            }
        }
        return true;
    }

    /**
     * 在握手之后执行该方法. 无论是否握手成功都指明了响应状态码和相应头
     */
    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response,
                               WebSocketHandler wsHandler, Exception ex) {
        //握手成功后
        // log.info(this.getClass().getCanonicalName() + "握手成功后...");
    }

}
