package com.onsiteservice.common.runner;

import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.mapper.sys.SysDictMapper;
import com.onsiteservice.entity.sys.SysDict;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * Springboot启动工程初始化数据到内存全局缓存中配置类
 * 如 字典表数据(使用注解翻译字典值)
 */

@Order(2)
@ConditionalOnProperty(prefix = "project.init-data", name = {"enabled"}, matchIfMissing = true)
@Component
@Slf4j
public class InitDataRunner implements CommandLineRunner {

    public static Map<String, List<Map>> dictData = new ConcurrentHashMap<>();

    @Resource
    private SysDictMapper sysDictMapper;

    @Override
    public void run(String... args) {
        // log.info("InitDataConfig初始化字典表数据到内存中");
        try {
            Thread.sleep(500);
            List<SysDict> list = sysDictMapper.selectAll().stream()
                    .filter(item -> item.getIsEnabled())
                    .sorted(Comparator.comparing(SysDict::getShowOrder))
                    .collect(Collectors.toList());
            if (list != null && list.size() > 0) {
                list.forEach(item -> {
                    if (dictData.containsKey(item.getTypeCode())) {
                        ArrayList newList = new ArrayList<>(dictData.get(item.getTypeCode()));
                        newList.add(Map.of("code", item.getCode(), "value", item.getValue()));
                        dictData.put(item.getTypeCode(), newList);
                    } else {
                        dictData.put(item.getTypeCode(), List.of(Map.of("code", item.getCode(), "value", item.getValue())));
                    }
                });
            }
        } catch (Exception e) {
            log.error("InitDataConfig初始化数据异常");
            throw new ServiceException("字典数据不存在");
        }
    }

}

