package com.onsiteservice.admin.service.sys;

import com.onsiteservice.admin.controller.sys.dto.SysDictPageDTO;
import com.onsiteservice.admin.controller.sys.dto.SysDictSaveDTO;
import com.onsiteservice.admin.controller.sys.vo.SysDictTypeDetailVO;
import com.onsiteservice.admin.mapper.sys.SysDictTypeBizMapper;
import com.onsiteservice.constant.constant.DictConstants;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.sys.SysDictMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.sys.SysDict;
import com.onsiteservice.entity.sys.SysDictType;
import com.onsiteservice.entity.sys.SysUser;
import com.onsiteservice.util.ArrayUtils;
import com.onsiteservice.util.CommonUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Condition;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author wang jianguo
 * @date 2021-07-23 10:37
 * SysDictTypeService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SysDictTypeService extends AbstractMapper<SysDictType> {

    @Resource
    private SysDictTypeBizMapper sysDictTypeBizMapper;

    @Resource
    private SysDictMapper sysDictMapper;

    /**
     * 分页查询
     *
     * @param param
     * @return com.anplus.admin.dto.SysCodePageDTO
     * @author linxianghua
     * @date 2019/10/12 10:39
     */
    public List<SysDictType> getPage(SysDictPageDTO param) {
        return sysDictTypeBizMapper.getPage(param);
    }

    /**
     * 分页查询
     *
     * @param id
     * @return com.anplus.admin.dto.SysCodePageDTO
     * @author linxianghua
     * @date 2019/10/12 10:39
     */
    public SysDictTypeDetailVO getDetail(Integer id) {
        SysDictTypeDetailVO vo = new SysDictTypeDetailVO();

        vo.setCodeMap(this.getCodeByTypes(DictConstants.SYS_DICT_CATEGORY));
        if (CommonUtils.isZero(id)) {
            vo.setSysCodeType(new SysDictType());
        } else {
            SysDictType sysCodeType = selectByPrimaryKey(id);
            vo.setSysCodeType(sysCodeType);
            vo.setCodeDetailList(sysDictTypeBizMapper.getSysCodeDetailList(sysCodeType.getCode()));
        }
        return vo;
    }

    private Map<String, List<SysDict>> getCodeByTypes(String... codeType) {
        if (ArrayUtils.isEmpty(codeType)) {
            return null;
        }
        List<SysDict> list = new ArrayList();
        for (String code : codeType) {
            List<SysDict> detailList = this.getCodeDetailList(code);
            if (ArrayUtils.isEmpty(detailList)) {
                continue;
            }
            list.addAll(detailList);
        }
        return this.process(list);
    }

    public List<SysDict> getCodeDetailList(String code) {
        if (Objects.isNull(code)) {
            return null;
        }
        return sysDictTypeBizMapper.getSysCodeDetailList(code);
    }

    /**
     * 设置通用代码映射
     *
     * @param detailList
     * @return
     */
    private Map<String, List<SysDict>> process(List<SysDict> detailList) {
        Map<String, List<SysDict>> resultMap = null;
        if (!ArrayUtils.isEmpty(detailList)) {
            resultMap = new HashMap<>(detailList.size());
            for (SysDict item : detailList) {
                String typeCode = item.getTypeCode();
                if (!resultMap.containsKey(typeCode)) {
                    resultMap.put(typeCode, new ArrayList<>());
                }
                resultMap.get(typeCode).add(item);
            }
        }
        return resultMap;
    }

    /**
     * @param param
     * @return java.lang.Integer
     * @author linxianghua
     * @date 2019/10/12 14:50
     */
    public Long saveCode(SysDictSaveDTO param, Long userId) {
        SysDictType sysCodeType = param.getSysCodeType();
        if (sysDictTypeBizMapper.getRepeat(sysCodeType.getId(), sysCodeType.getCode()) > 0) {
            throw new ServiceException("编号重复！");
        }
        //根据数据有无id判断是新建还是修改
        SysDictType type;
        if (CommonUtils.isZero(sysCodeType.getId())) {
            sysCodeType.setCreateBy(userId);
            insertSelective(sysCodeType);

        } else {
            type = this.selectByPrimaryKey(sysCodeType.getId());
            if (!type.getCode().equals(sysCodeType.getCode())) {
                sysDictTypeBizMapper.updateTypeCode(sysCodeType.getCode(), type.getCode());
            }

            EntityUtils.update(sysCodeType, userId);
            updateByPrimaryKeySelective(sysCodeType);
        }

        //保存明细新增数据
        if (ArrayUtils.isNotEmpty(param.getInsertList())) {
            for (SysDict item : param.getInsertList()) {
                item.setId(null);
                item.setCreateBy(userId);
                item.setTypeCode(sysCodeType.getCode());
                sysDictMapper.insertSelective(item);
            }
        }
        //保存明细修改数据
        if (ArrayUtils.isNotEmpty(param.getUpdateList())) {
            for (SysDict item : param.getUpdateList()) {
                EntityUtils.update(item, userId);
                item.setTypeCode(sysCodeType.getCode());
                sysDictMapper.updateByPrimaryKeySelective(item);
            }
        }
        //删除数据
        if (ArrayUtils.isNotEmpty(param.getDelIdList())) {
            sysDictMapper.deleteByIds(StringUtils.join(param.getDelIdList(), ","));
        }
        return sysCodeType.getId();
    }

    /**
     * 根据code删除
     *
     * @param codes
     */
    public void deleteByCodes(String... codes) {
        Condition condition = new Condition(SysDictType.class);
        condition.createCriteria().andIn("code", Arrays.asList(codes));
        this.deleteByCondition(condition);
    }

}
