package com.onsiteservice.admin.controller.user;

import com.onsiteservice.admin.controller.user.dto.UserPageDTO;
import com.onsiteservice.common.annotation.dict.Dict;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.constant.constant.DictConstants;
import com.onsiteservice.entity.user.User;
import com.onsiteservice.admin.service.user.UserService;

import com.onsiteservice.core.result.Result;
import com.onsiteservice.dao.common.page.PageInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;

import static com.onsiteservice.core.result.ResultGenerator.success;

/**
 * @author 商天翔
 * @date 2022-07-13 14:44
 * @description UserController控制类
 */
@ApiIgnore
@Api(tags = "UserController")
@RestController
@RequestMapping("/user")
@Validated
public class UserController {

    @Resource
    private UserService userService;


    @Dict(code = DictConstants.ROLE_TYPE, name = "roleType")
    @ApiOperation(value = "分页查询列表", notes = "作者: 商天翔")
    @PostMapping("/page")
    public Result<PageInfoVO> getPage(@RequestBody @NonNull @Validated UserPageDTO dto) {
        return success(userService.getPage(dto), "获取分页列表");
    }

    @ApiOperation(value = "根据id查询", notes = "作者: 商天翔")
    @GetMapping("/{id}")
    public Result<User> getDetails(@PathVariable @Positive Long id) {
        return success(userService.selectByPrimaryKey(id), "根据id获取详情");
    }

    @ApiOperation(value = "新增或修改", notes = "作者: 商天翔")
    @PutMapping
    public Result saveOrUpdate(@RequestBody @NonNull @Validated User user, @CurrentUserId Long userId) {
        return success(userService.update(user, userId), user.getId() == null ? "新增成功" : "修改成功");
    }


}
