package com.onsiteservice.admin.controller.sys;

import com.github.pagehelper.PageHelper;
import com.onsiteservice.admin.controller.sys.dto.SysRolePageDTO;
import com.onsiteservice.admin.controller.sys.dto.SysRoleSaveDTO;
import com.onsiteservice.admin.service.sys.SysRoleService;
import com.onsiteservice.common.annotation.user.CurrentUserId;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.common.page.PageInfoVO;
import com.onsiteservice.entity.sys.SysRole;
import com.onsiteservice.entity.sys.SysUser;
import io.swagger.annotations.Api;
import lombok.NonNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @author wang jianguo
 * @date 2021-07-22 17:42
 * SysRoleController控制类
 */
@ApiIgnore
@Api(tags = "SysRoleController")
@RestController
@RequestMapping("/sys/role")
@Validated
public class SysRoleController {

    @Resource
    private SysRoleService sysRoleService;

    /**
     * 分页查询列表
     *
     * @param param 分页参数
     * @return 分页数据
     */
    @PostMapping("/page")
    public Result pageList(@RequestBody SysRolePageDTO param) {
        PageHelper.startPage(param.getPage(), param.getSize());
        List<SysRole> list = sysRoleService.getPage(param);
        PageInfoVO pageInfo = new PageInfoVO(list);
        return ResultGenerator.success(pageInfo, "获取分页列表");
    }

    /**
     * 根据id查询
     *
     * @param id 主键
     * @return 详情数据
     */
    @GetMapping("/{id}")
    public Result findById(@PathVariable Integer id) {
        return ResultGenerator.success(sysRoleService.getDetail(id), "根据id获取详情");
    }

    /**
     * 新增保存对象
     *
     * @param param 保存对象
     */
    @PostMapping
    public Result save(@RequestBody @NonNull @Validated SysRoleSaveDTO param, @CurrentUserId Long sysUserId) {
        return ResultGenerator.success(sysRoleService.saveRole(param, sysUserId), "新增成功");
    }

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Integer id) {
        sysRoleService.deleteByPrimaryKey(id);
        return ResultGenerator.success("删除成功");
    }

    @GetMapping("/change/status/{id}")
    public Result changeOnline(@PathVariable Long id) {
        return ResultGenerator.success(sysRoleService.changeStatus(id), "修改使用状态");
    }

}
