package com.onsiteservice.miniapp.service.weixin.pay.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * @author: qiaobin
 * @description:
 * @date: 2019/1/22
 */
public class WechatPayMyConfigMini extends WXPayConfig {

    private String appID;
    private String mchID;
    private String key;

    public WechatPayMyConfigMini(String appID, String mchID, String key) {
        this.appID = appID;
        this.mchID = mchID;
        this.key = key;
    }

    private byte[] certData;


    public String getAppID() {
        return this.appID;
    }

    public String getMchID() {
        return this.mchID;
    }

    public String getKey() {
        return this.key;
    }

    public InputStream getCertStream() {
        ByteArrayInputStream certBis = new ByteArrayInputStream(this.certData);
        return certBis;
    }

    public int getHttpConnectTimeoutMs() {
        return 8000;
    }

    public int getHttpReadTimeoutMs() {
        return 10000;
    }

    @Override
    public IWXPayDomain getWXPayDomain() {
        return WXPayDomainSimpleImpl.instance();
    }

    public String getPrimaryDomain() {
        return "api.mch.weixin.qq.com";
    }

    public String getAlternateDomain() {
        return "api2.mch.weixin.qq.com";
    }
}
