package com.onsiteservice.miniapp.service.weixin;

import com.onsiteservice.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * 微信公众号消息服务
 */
@Service
@Slf4j
@Transactional(rollbackFor = Exception.class)
public class WeixinMessageService {

    @Autowired
    private WxMpService wxService;

    /**
     * 发送微信模板消息  批量发送处理
     */
    public void sendMsg(List<WxMpTemplateMessage> wxMpTemplateMessages) {
        for (WxMpTemplateMessage msg : wxMpTemplateMessages) {
            try {
                wxService.getTemplateMsgService().sendTemplateMsg(msg);
            } catch (Exception e) {
                e.printStackTrace();
                String errorMsg = e.getMessage();
                log.error("微信模板推送异常:" + errorMsg);
            }
        }
    }

    public WxMpTemplateMessage wxMpTemplateMessages() {
        List<WxMpTemplateMessage> msgList = new LinkedList<>();
        // 示例
        WxMpTemplateData keyword1 = new WxMpTemplateData();
        keyword1.setName("keyword1"); // 报警来源
        keyword1.setValue("");
        keyword1.setColor("#ff3334");
        WxMpTemplateData keyword2 = new WxMpTemplateData();
        keyword2.setName("keyword2"); // 发生时间
        keyword2.setValue(DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
        WxMpTemplateData keyword3 = new WxMpTemplateData();
        keyword3.setName("keyword3"); // 报警内容
        keyword3.setValue("dsadsd");
        keyword3.setColor("#ff3334");
        WxMpTemplateData remark = new WxMpTemplateData();
        remark.setName("remark");
        remark.setValue("请及时处理");

        List<WxMpTemplateData> dataList = List.of(keyword1, keyword2, keyword3, remark);

        String alarmNoticeTemplateId = ""; // 消息模板id
        String openId = ""; // 微信用户的公众号openId
        String appId = ""; // appid

        WxMpTemplateMessage.MiniProgram miniProgram = new WxMpTemplateMessage.MiniProgram();
        miniProgram.setAppid(appId);

        WxMpTemplateMessage wxMpTemplateMessage = WxMpTemplateMessage.builder()
                .templateId(alarmNoticeTemplateId).toUser(openId).miniProgram(miniProgram)
                .data(dataList).build();

        // TODO

        return null;
    }
}
