package com.onsiteservice.entity.service;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import tk.mybatis.mapper.annotation.LogicDelete;

@Getter
@Setter
@ToString
@ApiModel("估价员表")
@Table(name = "service_valuator_assign")
public class ServiceValuatorAssign implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("")
    private Long id;

    /**
     * 估价员id
     */
    @Column(name = "valuator_id")
    @ApiModelProperty("估价员id")
    private Long valuatorId;

    /**
     * 订单id
     */
    @Column(name = "order_id")
    @ApiModelProperty("订单id")
    private Long orderId;

    /**
     * 指派时间
     */
    @Column(name = "assign_time")
    @ApiModelProperty("指派时间")
    private Date assignTime;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @Column(name = "modify_time")
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @Column(name = "create_by")
    @ApiModelProperty("创建人")
    private Long createBy;

    @Column(name = "modify_by")
    @ApiModelProperty("修改人")
    private Long modifyBy;

    @Column(name = "deleted")
    @ApiModelProperty("删除标记")
    private Boolean deleted;

    @Column(name = "final_executed")
    @ApiModelProperty("最终上门的估价员")
    private Boolean finalExecuted;


    private static final long serialVersionUID = 1L;
}