package com.onsiteservice.common.converter;

import org.springframework.core.convert.converter.Converter;

import java.util.HashSet;
import java.util.Set;

/**
 * @author 潘维吉
 * @date 2019-03-25 10:52
 * 请求参数Boolean数据类型转换Number类型
 * true false 转成成 1 0
 */
public class BooleanToNumberConverter implements Converter<String, Byte> {

    private static Set<String> trueValues = new HashSet(4);
    private static Set<String> falseValues = new HashSet(4);

    static {
        trueValues.add("true");
        falseValues.add("false");
    }

    @Override
    public Byte convert(String source) {
        String value = source.trim();
        if (value.isEmpty()) {
            return null;
        } else {
            if (trueValues.contains(value)) {
                return 1;
            } else if (falseValues.contains(value)) {
                return 0;
            } else {
                throw new IllegalArgumentException("请求参数Boolean数据类型转换Number型异常: value '" + source + "'");
            }
        }
    }
}
