package com.onsiteservice.common.annotation.idempotent;

import com.onsiteservice.common.redis.RedisUtils;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.core.security.jwt.JwtManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @author 潘维吉
 * @date 2020/6/29 18:01
 * @email 406798106@qq.com
 * @description 幂等性服务
 */
@Service
public class ApiIdempotentService {

    @Autowired
    private RedisUtils redisUtils;

    /**
     * 创建token 并定时缓存
     */
    public void createToken(String businessToken, Long interval) {
        if (!redisUtils.exists(businessToken)) {
            redisUtils.set(businessToken, businessToken, interval, TimeUnit.MILLISECONDS);
        }
    }

    /**
     * 验证token
     */
    public void checkToken(HttpServletRequest request, Long interval) {
        String token = request.getHeader(JwtManager.AUTHORIZATION_HEADER).replace(JwtManager.BEARER, "");
        if (StringUtils.isBlank(token)) {  // header中不存在token
            token = request.getParameter("token");
            if (StringUtils.isBlank(token)) {  // parameter中也不存在token
                throw new ServiceException("用户token不存在");
            }
        }
        // 业务token唯一标识
        String businessToken = token + "-" + request.getMethod() + "-" + request.getRequestURI();

        if (redisUtils.exists(businessToken)) {
            throw new ServiceException("重复执行请求");
        }
        // 检测成功后后重新创建token缓存
        createToken(businessToken, interval);

    }
}
