package com.onsiteservice.admin.service.weixin;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaCodeLineColor;
import com.onsiteservice.common.service.dto.MiniQrCodeDTO;
import com.onsiteservice.core.exception.ServiceException;
import com.onsiteservice.core.result.Result;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import static com.onsiteservice.core.result.ResultGenerator.success;

@Transactional(rollbackFor = Exception.class)
@Service
public class AdminWeixinService {

    @Resource
    private WxMaService wxMaService;

    /**
     * 获取推广二维码
     */
    public Result getQrCode(MiniQrCodeDTO miniQrCodeDTO) {
        try {
            // 获取base64数据
            byte[] qrCode = wxMaService.getQrcodeService().createWxaCodeUnlimitBytes(miniQrCodeDTO.getScene(),
                    miniQrCodeDTO.getPath(), miniQrCodeDTO.getWidth(), false, new WxMaCodeLineColor("0", "0", "0"), false);
            return success(qrCode, "获取微信小程序码成功");
        } catch (Exception e) {
            throw new ServiceException("获取微信小程序码失败");
        }
    }


}
