package com.onsiteservice.admin.service.category;

import com.onsiteservice.dao.common.AbstractMapper;
import com.onsiteservice.dao.mapper.service.ServiceCategoryMapper;
import com.onsiteservice.dao.mapper.service.ServiceSubclassMapper;
import com.onsiteservice.dao.util.EntityUtils;
import com.onsiteservice.entity.category.ServiceCategory;
import com.onsiteservice.entity.category.ServiceSubclass;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * @author 商天翔
 * @date 2022-07-13 17:03
 * @description ServiceSubclassService服务类
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ServiceSubclassService extends AbstractMapper<ServiceSubclass> {

    @Resource
    private ServiceSubclassMapper serviceSubclassMapper;
    @Resource
    private ServiceCategoryMapper serviceCategoryMapper;

    /**
     * 保存或更新方法
     */
    public int saveOrUpdate(ServiceSubclass serviceSubclass, Long currentUserId) {
        if (serviceSubclass.getId() == null) {
            EntityUtils.insert(serviceSubclass, currentUserId);
            return this.insertSelective(serviceSubclass);
        } else {
            EntityUtils.update(serviceSubclass, currentUserId);
            return this.updateByPrimaryKeySelective(serviceSubclass);
        }
    }


    public List<Map> getSubClassSelectable() {
        List<ServiceCategory> categories = serviceCategoryMapper.selectAll();
        Map<Integer, String> categoryMap = categories.stream().collect(Collectors.toMap(ServiceCategory::getId, ServiceCategory::getServiceName));

        List<ServiceSubclass> subclassList = serviceSubclassMapper.selectAll();
        return subclassList.stream().sorted(Comparator.comparing(ServiceSubclass::getCategoryId))
                .map(sub -> Map.of("value", sub.getId(), "label", categoryMap.get(sub.getCategoryId()) + "-" + sub.getServiceName()))
                .collect(Collectors.toList());
    }
}
