package com.onsiteservice.admin.controller.sys;

import com.onsiteservice.admin.controller.sys.vo.SysBusinessTree;
import com.onsiteservice.admin.service.sys.SysBusinessService;
import com.onsiteservice.core.result.Result;
import com.onsiteservice.core.result.ResultGenerator;
import com.onsiteservice.dao.mapper.sys.SysBusinessMapper;
import com.onsiteservice.entity.sys.SysBusiness;
import lombok.AllArgsConstructor;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.constraints.Positive;
import java.util.List;

@RestController
@RequestMapping("/sys/business")
@Validated
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class SysBusinessController {

    private SysBusinessService sysBusinessService;
    private SysBusinessMapper sysBusinessMapper;

    @GetMapping("/")
    public Result<List<SysBusinessTree>> getAllList() {
        return ResultGenerator.success(sysBusinessService.getAllList(), "获取全部菜单列表");
    }

    /**
     * 新增保存对象
     *
     * @param sysBusiness 保存对象
     */
    @PostMapping
    public Result<SysBusiness> save(@RequestBody @NonNull @Validated SysBusiness sysBusiness) {
        sysBusinessService.insertSelective(sysBusiness);
        return ResultGenerator.success(sysBusiness, "新增成功");
    }

    /**
     * 更新修改对象
     *
     * @param sysBusiness 修改对象
     */
    @PutMapping
    public Result update(@RequestBody @NonNull @Validated SysBusiness sysBusiness) {
        sysBusinessService.updateByPrimaryKeySelective(sysBusiness);
        return ResultGenerator.success(sysBusiness, "更新成功");
    }

    /**
     * 根据id删除
     *
     * @param id 主键
     */
    @DeleteMapping("/{id}")
    public Result deleteById(@PathVariable @Positive Long id) {
        sysBusinessService.deleteByPrimaryKey(id);
        return ResultGenerator.success("删除成功");
    }

}