import { axios } from '@/util/axios/request'

const BASE_URL = '/worker'

export function searchWorkers(name) {
  return axios({
    url: `${BASE_URL}/search`,
    params: { name }
  })
}

export function getPage(data) {
  return axios({
    url: `${BASE_URL}/page`,
    method: 'post',
    data
  })
}

export function getDetail(id) {
  return axios({
    url: `${BASE_URL}/${id}`,
    method: 'get'
  })
}

export function save(data) {
  return axios({
    url: `${BASE_URL}/save`,
    method: 'post',
    data
  })
}

export function update(data) {
  return axios({
    url: `${BASE_URL}/update`,
    method: 'post',
    data
  })
}

export function deleteWorker(id) {
  return axios({
    url: `${BASE_URL}/delete/${id}`,
    method: 'delete',
  })
}