import {axios} from '@/util/axios/request'

const api = {
  getPage: '/sys/company/list',
  modify: '/sys/company/modify',
  add: '/sys/company/add',
  delete: '/sys/company/delete',
  export: '/sys/company/export',
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function modify(parameter) {
  return axios({
    url: api.modify,
    method: 'post',
    data: parameter,
  })
}

export function add(parameter) {
  return axios({
    url: api.add,
    method: 'post',
    data: parameter,
  })
}

export function deleteApi(id) {
  return axios({
    url: api.delete + `/${id}`,
    method: 'delete',
  })
}

export function exportData() {
  return axios({
    responseType: 'blob',
    headers: {'Accept': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'},
    url: api.export,
    method: 'post',
  })
}
