import {axios} from '@/util/axios/request'

const BASE_URL = '/service'


export function getCategoryList(data) {
  return axios({
    url: `${BASE_URL}/category-list`,
    method: 'post',
    data
  })
}


export function getDetails(id) {
  return axios({
    url: `${BASE_URL}/${id}`,
    method: 'get',
  })
}


export function getSubDetails(id) {
  return axios({
    url: `${BASE_URL}/sub-class/${id}`,
    method: 'get',
  })
}


export function updateCategory(data) {
  return axios({
    url: `${BASE_URL}/category`,
    method: 'post',
    data
  })
}

export function saveOrUpdateSubClass(data) {
  return axios({
    url: `${BASE_URL}/subclass`,
    method: 'post',
    data
  })
}



export function getSubClassSelectable() {
  return axios({
    url: `${BASE_URL}/subclass-selectable`,
    method: 'get',
  })
}