import { axios } from '@/util/axios/request'

const BASE_URL = '/home/notice'



export function getPage(data) {
  return axios({
    url: `${BASE_URL}/page`,
    method: 'post',
    data
  })
}


export function getDetail(id) {
  return axios({
    url: `${BASE_URL}/${id}`,
    method: 'get',
  })
}


export function save(data) {
  return axios({
    url: `${BASE_URL}/save-or-update`,
    method: 'post',
    data
  })
}

export function deleteOne(id) {
  return axios({
    url: `${BASE_URL}/${id}`,
    method: 'delete',
  })
}