import {axios} from '@/util/axios/request'

const BANNER_URL = '/banner'

export function getList() {
  return axios({
    url: `${BANNER_URL}/list`,
    method: 'post',
  })
}

export function getDetail(id) {
  return axios({
    url: `${BANNER_URL}/${id}`,
    method: 'get',
  })
}


export function save(parameter) {
  return axios({
    url: `${BANNER_URL}/save-or-update`,
    method: 'post',
    data: parameter,
    useFullLoading: true
  })
}

export function enable(parameter) {
  return axios({
    url: `${BANNER_URL}/enable`,
    method: 'put',
    data: parameter,
  })
}


export function deleteOne(id) {
  return axios({
    url: `${BANNER_URL}/${id}`,
    method: 'delete',
  })
}



