/**
 * 触发 window.resize
 */
import store from '@/store/index'
import {getCommonCode} from '@/api/system/sysCode'

export function triggerWindowResizeEvent() {
  let event = document.createEvent('HTMLEvents')
  event.initEvent('resize', true, true)
  event.eventType = 'message'
  window.dispatchEvent(event)
}


export function formatDate(date, fmt) {
  if(!date || date == 'Invalid Date' || date.getTime() == new Date(null).getTime()) {
    return"";
  }
  if (/(y+)/.test(fmt)) {
    fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length))
  }
  let o = {
    'M+': date.getMonth() + 1,
    'd+': date.getDate(),
    'h+': date.getHours(),
    'm+': date.getMinutes(),
    's+': date.getSeconds()
  }
  for (let k in o) {
    if (new RegExp(`(${k})`).test(fmt)) {
      let str = o[k] + ''
      fmt = fmt.replace(RegExp.$1, RegExp.$1.length === 1 ? str : padLeftZero(str))
    }
  }
  return fmt
}


// 驼峰转换下划线
export function humpToLine(name) {
  if(name){
    return name.replace(/([A-Z])/g,"_$1").toLowerCase();
  }else{
    return ''
  }
}
export function setOrder(name) {
  if (name === 'descend') {
    return 'desc'
  } else if(name === 'ascend'){
    return 'asc'
  }
}

export  function  handleWeek(weeks){
  if(weeks != null && weeks !=''){
    let weekArr = weeks.split("|"),weekText = [];
    if(weekArr.length>0){
      weekArr.map(m=>{
        switch (m){
          case '1':
            weekText.push("周一");
            break;
          case '2':
            weekText.push("周二");
            break;
          case '3':
            weekText.push("周三");
            break;
          case '4':
            weekText.push("周四");
            break;
          case '5':
            weekText.push("周五");
            break;
          case '6':
            weekText.push("周六");
            break;
          case '7':
            weekText.push("周日");
            break;
        }
      });
      return weekText.join("、");
    }
  }
  return "";
}
function padLeftZero (str) {
  return ('00' + str).substr(str.length)
}

// 用来控制按钮的显示
export function hasBtnPermission(permission) {
  const myBtns = store.getters.buttons;
  return myBtns.has(permission)
}

const bizCode = {
};

const bizCodeMapping = {
};

export { bizCode, bizCodeMapping };

/**
 * 从编码中获取字典值映射和下拉框选项数据
 */
 export function getCodeOptions(codes, valueFiled) {
  if(!valueFiled) {
    valueFiled = 'code';
  }
  return getCommonCode(codes).then(({ data }) => {
    const codeMapping = {};
    const options = {};
    Object.keys(data).forEach((k) => {
      const codeArray = data[k];
      const map = {};
      options[k] = codeArray.map(c => {
        map[c[valueFiled]] = c['value'];
        return {
          title: c['value'],
          value: c[valueFiled]
        };
      });
      codeMapping[k] = map;
    });
    return [codeMapping, options];
  });
}