export default {
  install(Vue) {
    Vue.prototype.$defaultPageSize = function () {
      let screenHeight = document.documentElement.clientHeight;
      let height = 10 //默认每页10条数据
      if (screenHeight > 1200) {
        height = 30
      } else if (screenHeight > 900) {
        height = 20
      } else if (screenHeight > 700) {
        height = 15
      }
      return height
    }

    Vue.prototype.$pageSizeOptions = ['10', '15', '20', '30', '50']

    Vue.prototype.$showTotal = total => `共 ${total} 条`;

    Vue.prototype.$valueCopy = (targetMap, sourceMap) => {
      let isModify = false;
      for (let key in sourceMap) {
        if (targetMap[key] != sourceMap[key]) {
          targetMap[key] = sourceMap[key]
          isModify = true
        }
      }
      if (targetMap.id && isModify == true) {
        targetMap.isModify = true
      }
      return targetMap
    }

    Vue.prototype.$codeToMap = (sourceCodeMap) => {
      let targetCodeMap = {}
      for(let key in sourceCodeMap){
        let codeList = sourceCodeMap[key];
        let tmpObject = {};
        codeList.map(m=>{
          tmpObject[m.valueInt] = m.name;
        })
        targetCodeMap[key] = tmpObject;
      }
      return targetCodeMap;
    }

    Vue.prototype.$batchDel = (list, delIndex, delIds) => {
      for (let i = 0, len = delIndex.length; i < len; i++) {
        let item = list[delIndex[i]]
        if (item.id) {
          delIds.push(item.id)
        }
        delete list[delIndex[i]]
      }
      return list.filter(item => item != undefined)
    }
    Vue.prototype.$batchDelByRowKey = (list, delIndex, delIds) => {
      for (let i = 0, len = delIndex.length; i < len; i++) {
        let delId = delIndex[i];
        for (let j = 0; j < list.length; j++) {
          if (list[j] && list[j].id == delId) {
            if (delId > 0) {
              delIds.push(delId)
            }
            delete list[j]
          }
        }
      }
      return list.filter(item => item != undefined)
    }

    Vue.prototype.$isEmptyStr = (str) => {
      if (str == null || str == undefined || str.length == 0) {
        return true;
      }
      return false;
    }

    Vue.prototype.$extractList = (itemList) => {
      let updateList = []
      let insertList = []
      if (itemList && itemList.length > 0) {//单元列表不为空且长度至少为1
        for (let item of itemList) {//表示为修改
          if (item.id && item.id>0) {
            if (item.isModify) {
              updateList.push(item)
            }
          } else {
            insertList.push(item)
          }
        }
        return {
          'insertList': insertList,
          'updateList': updateList
        }
      }else{//表示为新建
        return {
          'insertList': [],
          'updateList': []
        }
      }
    }
  }

}