import {axios} from '@/util/axios/request'

const api = {
  getPage: '/sys/dict/type/page',
  getDetail: '/sys/dict/type/',
  deleteOne: '/sys/dict/type/',
  deleteBatch: '/sys/dict/type/batchDelete',
  save: '/sys/dict/type/',
  commCodePath: '/dict'
}

export default api

export function getPage(parameter) {
  return axios({
    url: api.getPage,
    method: 'post',
    data: parameter,
  })
}

export function getDetail(id) {
  return axios({
    url: api.getDetail + id,
    method: 'get',
    useFullLoading: true
  })
}

export function deleteOne(id) {
  return axios({
    url: api.deleteOne+id,
    method: 'delete'
  })
}

export function deleteBatch(parameter) {
  return axios({
    url: api.deleteBatch,
    method: 'post',
    data: parameter
  })
}

export function save(data) {
  return axios({
    url: api.save,
    method: 'post',
    data: data,
    useFullLoading: true
  })
}

export function getCommonCode(codes) {
  return axios({
    url: `${api.commCodePath}/${codes.join(',')}`,
    method: 'get',
  })
}


