import { axios } from '@/util/axios/request'

const BASE_URL = '/order'

export function getPage(data) {
  return axios({
    url: `${BASE_URL}/page`,
    method: 'post',
    data
  })
}

export function getDetail(id) {
  return axios({
    url: `${BASE_URL}/${id}`,
    method: 'get',
  })
}

// 指派估价员
export function dispatchValuator(data) {
  return axios({
    url: `${BASE_URL}/valuation`,
    method: 'post',
    useFullLoading: true,
    data
  })
}

// 重新指派估价员
export function reDispatchValuator(data) {
  return axios({
    url: `${BASE_URL}/revaluation`,
    method: 'post',
    useFullLoading: true,
    data
  })
}

// 确定价格发送订单
export function sendPrice(data) {
  return axios({
    url: `${BASE_URL}/send`,
    method: 'post',
    useFullLoading: true,
    data
  })
}


// 订单状态
export const STATUS = {
  RESERVE: 1, // 已提交
  VALUATION: 2, // 待估价
  SEND: 3, // 已估价，待支付
  PAY: 4, // 已付款
  DISPATCH: 5, // 已派单
}