import type { VNode } from 'vue';

import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { DictDataApi } from '#/api/system/dict/dictData';

import { Tag } from 'ant-design-vue';
// import { getTagDicts } from '#/utils/dict';

// export function getTagOptions() {
//   return [
//   ];
// }

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'dictId',
  //   label: '字典类型ID',
  // },
  {
    component: 'Input',
    fieldName: 'dictLabel',
    label: '字典标签',
  },
  {
    component: 'Input',
    fieldName: 'dictValue',
    label: '字典键值',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<DictDataApi.DictData>,
): VxeTableGridOptions<DictDataApi.DictData>['columns'] {
  return [
    // {
    //   title: '字典类型ID',
    //   field: 'dictId',
    //   width: 120,
    // },
    // {
    //   title: '字典类型',
    //   field: 'dictType',
    //   width: 150,
    // },
    {
      title: '字典标签',
      field: 'dictLabel',
      slots: { default: 'dictLabel' },
    },
    {
      title: '字典键值',
      field: 'dictValue',
    },
    {
      title: '排序',
      field: 'dictSort',
    },
    {
      title: '描述',
      field: 'description',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'dictLabel',
          nameTitle: '字典明细',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:dict:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:dict:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}

interface TagType {
  color: string;
  label: string;
}
interface Options {
  label: string | VNode;
  value: string;
}

const tagTypes: TagType[] = [
  { color: 'cyan', label: 'cyan' },
  { color: 'error', label: '危险(danger)' },
  /** 由于和elementUI不同 用于替换颜色 */
  { color: 'default', label: '默认(default)' },
  { color: 'green', label: 'green' },
  // { color: 'default', label: '信息(info)' },
  { color: 'orange', label: 'orange' },
  /** 自定义预设 color可以为16进制颜色 */
  { color: 'pink', label: 'pink' },
  { color: 'processing', label: '主要(primary)' },
  { color: 'purple', label: 'purple' },
  { color: 'red', label: 'red' },
  { color: 'success', label: '成功(success)' },
  { color: 'warning', label: '警告(warning)' },
];

export function tagSelectOptions() {
  const selectArray: Options[] = [];
  tagTypes.forEach((item) => {
    if (!item) return;
    const label = item.label;
    const color = item.color;
    selectArray.push({
      label: <Tag color={color}>{label}</Tag>,
      value: color,
    });
  });
  return selectArray;
}
