import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace DictDataApi {
  export interface DictData extends BaseModel {
    /**
     * 字典类型
     */
    dictType?: string;
    /**
     * 字典标签
     */
    dictLabel: string;
    /**
     * 字典键值
     */
    dictValue: string;
    /**
     * 样式属性（其他样式扩展）
     */
    listClass?: string;
    /**
     * 排序
     */
    dictSort?: number;
    /**
     * 描述
     */
    description?: string;
  }
}

/**
 * 查询字典明细列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/dict/data/page', { params });
}
/**
 * 根据字典类型查询字典数据信息
 * @params dictType
 * @returns {*}
 */
export function apiGetDicts(dictType: string) {
  return requestClient.get(`/system/dict/data/type/${dictType}`);
}
/**
 * 查询字典明细详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/dict/data/${id}`);
}
/**
 * 新增字典明细
 * @param data
 */
export function apiAdd(data: DictDataApi.DictData) {
  return requestClient.post('/system/dict/data', data);
}
/**
 * 修改字典明细
 * @param data
 */
export function apiUpdate(data: DictDataApi.DictData) {
  return requestClient.put('/system/dict/data', data);
}
/**
 * 删除字典明细
 * @param id
 */
export function apiDelete(id: number) {
  return requestClient.delete(`/system/dict/data/${id}`);
}
/**
 * 导出字典明细
 * @param params
 */
export function apiExport(params: PageQuery) {
  return requestClient.post('/system/dict/data/export', params);
}
