import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysJobApi } from '#/api/system/sysJob';

import { DictEnum } from '@vben/constants';

import { getDictOptions, getTagDicts } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'className',
    label: 'bean名称',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'methodName',
  //   label: '方法名',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'params',
  //   label: '参数',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_JOB_TYPE),
    },
    fieldName: 'jobType',
    label: '类型',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_JOB_STATUS, true),
    },
    fieldName: 'status',
    label: '任务状态',
  },
  {
    component: 'Input',
    fieldName: 'clientKey',
    label: '系统标识',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysJobApi.SysJob>,
): VxeTableGridOptions<SysJobApi.SysJob>['columns'] {
  return [
    {
      title: '类型',
      field: 'jobType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_JOB_TYPE)],
      },
    },
    {
      title: 'bean名称',
      field: 'className',
    },
    {
      title: '方法名',
      field: 'methodName',
    },
    {
      title: '参数',
      field: 'params',
    },
    {
      title: 'cron表达式',
      field: 'cronExpression',
    },
    {
      title: '任务状态',
      field: 'status',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_JOB_STATUS, true)],
      },
    },
    // {
    //   title: '备注',
    //   field: 'remark',
    // },
    {
      title: '系统标识',
      field: 'clientKey',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'className',
          nameTitle: '定时任务',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:job:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:job:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
