import type { RouteRecordRaw } from 'vue-router';

const routes: RouteRecordRaw[] = [
  // 人事管理
  {
    path: '/hr',
    name: 'HrManagement',
    meta: {
      title: '人事管理',
      keepAlive: true,
      icon: 'streamline-ultimate:human-resources-hierarchy-1',
      permission: ['dashboard'],
    },
    children: [
      {
        path: '/hr/employee/list',
        name: 'EmployeeInfoList',
        component: () => import('#/views/hr/employeeInfo/list.vue'),
        meta: {
          title: '员工信息列表',
          icon: 'clarity:employee-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/hr/employeeInfo/list.vue',
        },
      },
    ],
  },
];

export default routes;
