import type { RouteMeta as IRouteMeta } from '@vben-core/typings';

import 'vue-router';

declare module 'vue-router' {
  // eslint-disable-next-line @typescript-eslint/no-empty-object-type
  interface RouteMeta extends IRouteMeta {}
}

export interface VbenAdminProAppConfigRaw {
  VITE_GLOB_API_URL: string;
  // 客户端ID
  VITE_GLOB_APP_CLIENT_ID: string;
  VITE_GLOB_AUTH_DINGDING_CLIENT_ID: string;
  VITE_GLOB_AUTH_DINGDING_CORP_ID: string;
  // 是否开启sse  注意从配置文件获取的类型为string
  VITE_GLOB_SSE_ENABLE: string;
  // 开启websocket  注意从配置文件获取的类型为string
  VITE_GLOB_WEBSOCKET_ENABLE: string;
}

interface AuthConfig {
  dingding?: {
    clientId: string;
    corpId: string;
  };
}

export interface ApplicationConfig {
  apiURL: string;
  // 客户端key
  clientId: string;
  // 是否开启sse
  sseEnable: boolean;
  auth: AuthConfig;
  // 是否开启
  websocketEnable: boolean;
}

declare global {
  interface Window {
    _VBEN_ADMIN_PRO_APP_CONF_: VbenAdminProAppConfigRaw;
  }
}
