import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { NoticeApi } from '#/api/system/notice';

import { DictEnum } from '@vben/constants';
import { getVxePopupContainer } from '@vben/utils';

import { getDictOptions, getTagDicts } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'noticeTitle',
    label: '公告标题',
  },
  {
    component: 'Select',
    componentProps: {
      getVxePopupContainer,
      options: getDictOptions(DictEnum.SYS_NOTICE_TYPE),
    },
    fieldName: 'noticeType',
    label: '公告类型',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<NoticeApi.Notice>,
): VxeTableGridOptions<NoticeApi.Notice>['columns'] {
  return [
    {
      title: '公告标题',
      field: 'noticeTitle',
    },
    {
      title: '公告类型',
      field: 'noticeType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_NOTICE_TYPE)],
      },
    },
    {
      title: '公告内容',
      field: 'noticeContent',
    },
    {
      title: '公告状态',
      field: 'status',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_COMMON_STATUS, true)],
      },
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '通知公告',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:notice:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:notice:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
