import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysClientApi } from '#/api/system/sysClient';

import { useAccess } from '@vben/access';
import { DictEnum } from '@vben/constants';

import { changeStatus } from '#/api/system/sysClient';
import { getDictOptions, getTagDicts } from '#/utils/dict';

const { hasAccessByCodes } = useAccess();
export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'clientKey',
    label: '客户端key',
  },
  {
    component: 'Input',
    fieldName: 'clientSecret',
    label: '客户端秘钥',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'activeTimeout',
  //   label: 'token活跃超时时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'timeout',
  //   label: 'token固定超时时间',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_COMMON_STATUS, true),
    },
    fieldName: 'status',
    label: '状态',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysClientApi.Client>,
): VxeTableGridOptions<SysClientApi.Client>['columns'] {
  return [
    {
      title: '客户端id',
      field: 'clientId',
      showOverflow: true,
      // width: 120,
    },
    {
      title: '客户端key',
      field: 'clientKey',
      // width: 120,
    },
    {
      title: '客户端秘钥',
      field: 'clientSecret',
      // width: 120,
    },
    {
      title: '授权类型',
      field: 'grantTypeList',
      cellRender: { name: 'CellTag', options: [getTagDicts('sys_grant_type')] },
    },
    {
      title: '设备类型',
      field: 'deviceType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts('sys_device_type')],
      },
    },
    {
      title: 'token活跃超时时间',
      field: 'activeTimeout',
      formatter({ row }) {
        return `${row.activeTimeout}秒`;
      },
    },
    {
      title: 'token固定超时时间',
      field: 'timeout',
      formatter({ row }) {
        return `${row.timeout}秒`;
      },
    },
    {
      title: '状态',
      field: 'status',
      cellRender: {
        name: 'CellSwitch',
        props: {
          api: changeStatus,
          confirm: true,
          disabled: (row: SysClientApi.Client) => {
            return row.id === 1 || !hasAccessByCodes(['system:client:edit']);
          },
        },
      },
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'clientKey',
          nameTitle: '终端信息',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['system:client:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            accessCode: ['system:client:remove'],
          }, // 默认的删除按钮
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
