import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysUserApi } from '#/api/auth/user';

import { useAccess } from '@vben/access';
import { DictEnum } from '@vben/constants';

import { enableUser } from '#/api/auth/user';
import { getDictOptions } from '#/utils/dict';

// export function getTagOptions() {
//   return [
//   ];
// }
const { hasAccessByCodes } = useAccess();
export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Input',
    fieldName: 'username',
    label: '登录用户名',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'password',
  //   label: '登录密码',
  // },
  {
    component: 'Input',
    fieldName: 'phone',
    label: '电话',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'email',
  //   label: '邮箱',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'isAdmin',
  //   label: '是否为默认管理员,超级管理员',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_COMMON_STATUS, true),
    },
    fieldName: 'isEnable',
    label: '状态',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'deptId',
  //   label: '部门',
  // },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysUserApi.User>,
): VxeTableGridOptions<SysUserApi.User>['columns'] {
  return [
    {
      title: '姓名',
      field: 'name',
      width: 120,
    },
    {
      title: '登录用户名',
      field: 'username',
      width: 120,
    },
    // {
    //   title: '登录密码',
    //   field: 'password',
    //   width: 120,
    // },
    {
      title: '电话',
      field: 'phone',
      width: 120,
    },
    // {
    //   title: '邮箱',
    //   field: 'email',
    //   width: 120,
    // },
    // {
    //   title: '是否为默认管理员,超级管理员',
    //   field: 'isAdmin',
    //   width: 120,
    // },
    {
      title: '状态',
      field: 'isEnable',
      width: 100,
      cellRender: {
        name: 'CellSwitch',
        props: {
          api: enableUser,
          confirm: true,
          disabled: (row: SysUserApi.User) => {
            return row.id === 1 || !hasAccessByCodes(['auth:user:edit']);
          },
        },
      },
    },
    {
      title: '部门',
      field: 'deptName',
      width: 120,
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '系统用户',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit',
            accessCode: ['auth:user:edit'],
          }, // 默认的编辑按钮
          {
            code: 'delete',
            text: '删除',
            danger: true,
            disabled: (row: SysUserApi.User) => {
              return !!(row.id === 1);
            },
            accessCode: ['auth:user:remove'],
          },
          {
            code: 'resetPwd',
            text: '重置密码',
            disabled: (row: SysUserApi.User) => {
              return !!(row.id === 1);
            },
            accessCode: ['auth:user:edit'],
          },
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
