import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysMenuApi } from '#/api/auth/menu';

import { h } from 'vue';

import { FolderIcon, MenuIcon, OkButtonIcon } from '@vben/icons';

export function getMenuTypeOptions() {
  return [
    {
      color: 'processing',
      label: '目录',
      value: 0,
    },
    { color: 'success', label: '菜单', value: 1 },
    { color: 'warning', label: '按钮', value: 2 },
  ];
}

export function getVisibleOptions() {
  return [
    { color: 'processing', label: '显示', value: 1 },
    { color: 'warning', label: '隐藏', value: 0 },
  ];
}

export function getCacheOptions() {
  return [
    { color: 'processing', label: '缓存', value: 1 },
    { color: 'warning', label: '不缓存', value: 0 },
  ];
}

const menuTypes = {
  0: { icon: FolderIcon, value: '目录' },
  1: { icon: MenuIcon, value: '菜单' },
  2: { icon: OkButtonIcon, value: '按钮' },
};

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'key',
    label: '菜单名称 ',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysMenuApi.menu>,
): VxeTableGridOptions<SysMenuApi.menu>['columns'] {
  return [
    {
      field: 'name',
      fixed: 'left',
      // slots: { default: 'title' },
      title: '菜单名称',
      treeNode: true,
      width: 250,
      // 层级更明显显示
      align: 'left',
    },
    {
      align: 'center',
      // cellRender: { name: 'CellTag', options: getMenuTypeOptions() },
      field: 'type',
      title: '菜单类型',
      width: 100,
      slots: {
        default: ({ row }) => {
          const current = menuTypes[row.type as 0 | 1 | 2];
          if (!current) {
            return '未知';
          }
          return (
            <span class="flex items-center justify-center gap-1">
              {h(current.icon, { class: 'size-[18px]' })}
              <span>{current.value}</span>
            </span>
          );
        },
      },
    },
    {
      align: 'center',
      field: 'perms',
      title: '权限标识',
      width: 220,
    },
    {
      align: 'center',
      field: 'pageName',
      title: '页面名称',
      width: 180,
    },
    {
      title: '显示',
      field: 'visible',
      width: 100,
      cellRender: { name: 'CellTag', options: getVisibleOptions() },
    },
    // {
    //   title: '是否缓存',
    //   field: 'isCache',
    //   width: 100,
    //   cellRender: { name: 'CellTag', options: getCacheOptions() },
    // },
    {
      title: '排序',
      field: 'orderNum',
      width: 120,
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '菜单',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'append',
            text: '新增下级',
            disabled: (row: SysMenuApi.menu) => {
              return !!(row.type && row.type === 2);
            },
            accessCode: ['auth:menu:add'],
          },
          {
            // 默认的编辑按钮
            code: 'edit',
            accessCode: ['auth:menu:edit'],
          },
          {
            // 默认的删除按钮
            code: 'delete',
            accessCode: ['auth:menu:remove'],
          },
        ],
      },
      field: 'action',
      fixed: 'right',
      // slots: { default: 'action' },
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      minWidth: 200,
    },
  ];
}
