import type { RouteRecordRaw } from 'vue-router';

const routes: RouteRecordRaw[] = [
  {
    name: 'Demo5',
    path: '/demo',
    // hidden: false,
    // redirect: 'noRedirect',
    // component: 'Layout',
    // alwaysShow: true,
    meta: {
      title: '流程发起',
      icon: 'devicon:vscode',
      noCache: false,
      // link: null,
    },
    children: [
      {
        name: 'LeaveApply',
        path: 'leave',
        // hidden: false,
        component: () => import('#/views/workflow/leave/index.vue'),
        meta: {
          title: '请假申请',
          icon: 'fluent-mdl2:leave-user',
          noCache: false,
          componentPath: '#/views/workflow/leave/index.vue',
          // link: null,
        },
      },
    ],
  },
  {
    name: 'Workflow',
    path: '/workflow',
    // hidden: false,
    // redirect: 'noRedirect',
    // component: 'Layout',
    // alwaysShow: true,
    meta: {
      title: '工作流',
      icon: 'mdi:workflow-outline',
      noCache: false,
      // link: null,
    },
    children: [
      {
        name: 'WorkflowCategory',
        path: 'category',
        // hidden: false,
        component: () => import('#/views/workflow/category/index.vue'),
        // component: 'workflow/category/index',
        meta: {
          title: '流程分类',
          icon: 'tabler:category-plus',
          noCache: false,
          componentPath: '#/views/workflow/category/index.vue',
          // link: null,
        },
      },
      {
        name: 'WorkflowSpel',
        path: 'spel',
        // hidden: false,
        component: () => import('#/views/workflow/spel/index.vue'),
        // component: 'workflow/spel/index',
        meta: {
          title: '流程表达式',
          icon: 'material-symbols:regular-expression-rounded',
          noCache: false,
          componentPath: '#/views/workflow/spel/index.vue',
          // link: null,
        },
      },
      {
        name: 'ProcessDefinition',
        path: 'processDefinition',
        // hidden: false,
        component: () => import('#/views/workflow/processDefinition/index.vue'),
        // component: 'workflow/processDefinition/index',
        meta: {
          title: '流程定义',
          icon: 'fluent-mdl2:build-definition',
          noCache: true,
          componentPath: '#/views/workflow/processDefinition/index.vue',
          // link: null,
        },
      },
      {
        name: 'WorkflowMonitor',
        path: 'monitor',
        // hidden: false,
        // redirect: 'noRedirect',
        // component: () => import('#/views/workflow/leave/index.vue'),
        // component: 'ParentView',
        // alwaysShow: true,
        meta: {
          title: '流程监控',
          icon: 'icon-park-outline:monitor',
          noCache: false,
          // link: null,
        },
        children: [
          {
            name: 'ProcessInstance',
            path: 'processInstance',
            // hidden: false,
            component: () =>
              import('#/views/workflow/processInstance/index.vue'),
            // component: 'workflow/processInstance/index',
            meta: {
              title: '流程实例',
              icon: 'ri:instance-line',
              noCache: true,
              componentPath: '#/views/workflow/processInstance/index.vue',
              // link: null,
            },
          },
          {
            name: 'AllTaskWaiting',
            path: 'allTaskWaiting',
            // hidden: false,
            component: () => import('#/views/workflow/task/allTaskWaiting.vue'),
            // component: 'workflow/task/allTaskWaiting',
            meta: {
              title: '待办任务',
              icon: 'ri:todo-line',
              noCache: true,
              componentPath: '#/views/workflow/task/allTaskWaiting.vue',
              // link: null,
            },
          },
        ],
      },
      {
        name: 'WorkFlowDesign',
        path: 'design/index',
        // hidden: true,
        component: () =>
          import('#/views/workflow/processDefinition/design.vue'),
        // component: 'workflow/processDefinition/design',
        meta: {
          title: '流程设计',
          icon: 'fluent-mdl2:flow',
          noCache: true,
          hideInMenu: true,
          componentPath: '#/views/workflow/processDefinition/design.vue',
          // link: null,
        },
      },
      {
        name: 'WorkFlowLeaveEdit',
        path: 'leaveEdit/index',
        // hidden: true,
        component: () => import('#/views/workflow/leave/index.vue'),
        // component: 'workflow/leave/leaveEdit',
        meta: {
          title: '请假申请',
          icon: 'flat-color-icons:leave',
          noCache: true,
          hideInMenu: true,
          componentPath: '#/views/workflow/leave/index.vue',
          // link: null,
        },
      },
    ],
  },
  {
    name: 'Task',
    path: '/task',
    // hidden: false,
    // redirect: 'noRedirect',
    // component: 'Layout',
    // alwaysShow: true,
    meta: {
      title: '我的任务',
      icon: 'carbon:task-approved',
      noCache: false,
      // link: null,
    },
    children: [
      {
        name: 'MyDocument',
        path: 'myDocument',
        // hidden: false,
        component: () => import('#/views/workflow/task/myDocument.vue'),
        meta: {
          title: '我发起的',
          icon: 'ic:round-launch',
          noCache: true,
          componentPath: '#/views/workflow/task/myDocument.vue',
          // link: null,
        },
      },
      {
        name: 'TaskWaiting',
        path: 'taskWaiting',
        // hidden: false,
        component: () => import('#/views/workflow/task/taskWaiting.vue'),
        // component: 'workflow/task/taskWaiting',
        meta: {
          title: '我的待办',
          icon: 'ri:todo-line',
          noCache: true,
          componentPath: '#/views/workflow/task/taskWaiting.vue',
          // link: null,
        },
      },
      {
        name: 'TaskFinish',
        path: 'taskFinish',
        // hidden: false,
        component: () => import('#/views/workflow/task/taskFinish.vue'),
        // component: 'workflow/task/taskFinish',
        meta: {
          title: '我的已办',
          icon: 'material-symbols:cloud-done-outline-rounded',
          noCache: true,
          componentPath: '#/views/workflow/task/taskFinish.vue',
          // link: null,
        },
      },
      {
        name: 'TaskCopyList',
        path: 'taskCopyList',
        // hidden: false,
        component: () => import('#/views/workflow/task/taskCopyList.vue'),
        // component: 'workflow/task/taskCopyList',
        meta: {
          title: '我的抄送',
          icon: 'mdi:cc-outline',
          noCache: true,
          componentPath: '#/views/workflow/task/taskCopyList.vue',
          // link: null,
        },
      },
    ],
  },
];

export default routes;
