import type { RouteRecordRaw } from 'vue-router';

const routes: RouteRecordRaw[] = [
  // 权限管理
  {
    path: '/auth',
    name: 'Auth',
    meta: {
      title: '权限管理',
      keepAlive: true,
      icon: 'lucide:tree-palm',
      permission: ['dashboard'],
    },
    children: [
      {
        path: '/auth/user/list',
        name: 'SysUserList',
        component: () => import('#/views/auth/user/list.vue'),
        meta: {
          title: '用户列表',
          icon: 'ant-design:user-outlined',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/user/list.vue',
        },
      },
      {
        path: '/auth/role/list',
        name: 'SysRoleList',
        component: () => import('#/views/auth/role/list.vue'),
        meta: {
          title: '角色列表',
          icon: 'eos-icons:role-binding-outlined',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/role/list.vue',
        },
      },
      {
        path: '/auth/menu/list',
        name: 'SysMenuList',
        component: () => import('#/views/auth/menu/list.vue'),
        meta: {
          title: '菜单列表',
          icon: 'lucide:square-menu',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/menu/list.vue',
        },
      },
      {
        path: '/auth/dept/list',
        component: () => import('#/views/auth/dept/list.vue'),
        name: 'SysDeptList',
        meta: {
          title: '部门列表',
          icon: 'mingcute:department-line',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/dept/list.vue',
        },
      },
      {
        path: '/auth/post/list',
        component: () => import('#/views/auth/post/list.vue'),
        name: 'SysPostList',
        meta: {
          title: '岗位列表',
          icon: 'icon-park-outline:appointment',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/post/list.vue',
        },
      },
      {
        path: '/auth/role-auth/user/:roleId',
        component: () => import('#/views/auth/roleAssign/list.vue'),
        name: 'RoleAssignList',
        meta: {
          title: '分配用户',
          icon: 'mingcute:department-line',
          keepAlive: true,
          hideInMenu: true,
          permission: ['dashboard'],
          componentPath: '#/views/auth/roleAssign/list.vue',
        },
      },
    ],
  },
  // 租户管理
  {
    path: '/tenant',
    name: 'SysTenant',
    meta: {
      title: '租户管理',
      keepAlive: true,
      icon: 'ph:users-light',
      permission: ['dashboard'],
    },
    children: [
      {
        path: '/system/tenant/list',
        component: () => import('#/views/system/tenant/list.vue'),
        name: 'SysTenantList',
        meta: {
          title: '租户管理',
          icon: 'ph:user-list',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/tenant/list.vue',
        },
      },
      {
        path: '/system/tenant/package/list',
        component: () => import('#/views/system/tenantPackage/list.vue'),
        name: 'SysTenantPackageList',
        meta: {
          title: '套餐管理',
          icon: 'bx:package',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/tenantPackage/list.vue',
        },
      },
    ],
  },
  // 系统管理
  {
    path: '/system',
    name: 'System',
    meta: {
      title: '系统管理',
      keepAlive: true,
      icon: 'eos-icons:system-group',
      permission: ['dashboard'],
    },
    children: [
      // {
      //   path: '/system/sysJobList',
      //   component: () => import('#/views/system/job/list.vue'),
      //   name: 'SysJobList',
      //   meta: { title: '定时器', keepAlive: true, permission: ['dashboard'] },
      // },
      {
        path: '/system/sysDict/list',
        component: () => import('#/views/system/dict/index.vue'),
        name: 'SysDictList',
        meta: {
          title: '字典管理',
          icon: 'fluent-mdl2:dictionary',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/dict/index.vue',
        },
      },
      {
        path: '/system/sysConfig/list',
        component: () => import('#/views/system/config/list.vue'),
        name: 'SysConfigList',
        meta: {
          title: '参数配置',
          icon: 'ant-design:setting-outlined',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/config/list.vue',
        },
      },
      {
        path: '/system/client/list',
        component: () => import('#/views/system/client/list.vue'),
        name: 'SysClientList',
        meta: {
          title: '客户端管理',
          icon: 'solar:monitor-smartphone-outline',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/client/list.vue',
        },
      },
      {
        path: '/system/notice/list',
        name: 'SysNoticeList',
        component: () => import('#/views/system/notice/list.vue'),
        meta: {
          title: '通知公告',
          icon: 'fe:notice-push',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/notice/list.vue',
        },
      },
      {
        path: '/system/sysJob/list',
        name: 'SysJobList',
        component: () => import('#/views/system/job/list.vue'),
        meta: {
          title: '定时任务',
          icon: 'carbon:event-schedule',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/job/list.vue',
        },
      },
      {
        path: '/system/oss/list',
        name: 'SysOssList',
        component: () => import('#/views/system/oss/list.vue'),
        meta: {
          title: '文件管理',
          icon: 'carbon:event-schedule',
          keepAlive: true,
          permission: ['dashboard'],
          componentPath: '#/views/system/oss/list.vue',
        },
      },
      {
        path: '/system/log',
        name: 'SystemLog',
        meta: {
          title: '日志管理',
          keepAlive: true,
          icon: 'material-symbols:logo-dev-outline',
          permission: ['dashboard'],
        },
        children: [
          {
            path: '/system/sysLog/list',
            name: 'SysLogList',
            component: () => import('#/views/system/log/sysLog/list.vue'),
            meta: {
              title: '操作日志',
              icon: 'arcticons:one-hand-operation',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/system/log/sysLog/list.vue',
            },
          },
          {
            path: '/system/loginLog/list',
            name: 'SysLoginLogList',
            component: () => import('#/views/system/log/loginLog/list.vue'),
            meta: {
              title: '登陆日志',
              icon: 'streamline:interface-login-dial-pad-finger-password-dial-pad-dot-finger',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/system/log/loginLog/list.vue',
            },
          },
          {
            path: '/system/jobLog/list',
            name: 'SysJobLogList',
            component: () => import('#/views/system/job/jobLog/list.vue'),
            meta: {
              title: '任务日志',
              icon: 'arcticons:one-hand-operation',
              keepAlive: true,
              permission: ['dashboard'],
              componentPath: '#/views/system/job/jobLog/list.vue',
            },
          },
        ],
      },
      // {
      //   path: '/system/districtsList',
      //   component: () => import('#/views/system/districts/list.vue'),
      //   name: 'DistrictsList',
      //   meta: { title: '地区管理', keepAlive: true, permission: ['dashboard'] },
      // },
      // {
      //   path: '/system/sysJobLogList',
      //   component: () => import('#/views/system/jobLog/list.vue'),
      //   name: 'SysJobLogList',
      //   meta: {
      //     title: '定时任务日志',
      //     keepAlive: true,
      //     permission: ['dashboard'],
      //   },
      // },
    ],
  },
];

export default routes;
